<?php
global $disable_ads;
global $show_comments;
global $show_tags;
global $post;
global $ctr_custom;
$ctr_custom = get_post_custom($post->ID);

if(is_array($ctr_custom) && array_key_exists('ctr_disable_ads', $ctr_custom)) $disable_ads = true;
if(!$disable_ads) session_start();

// Get Theme Options for the CTR Theme
$subtheme = get_option('ctr_ad_subtheme');
if(!$subtheme) $subtheme = 'lightInfo';

global $subtheme_dir;
global $subtheme_url;

$subtheme_dir = TEMPLATEPATH . '/ctr/subthemes/' . $subtheme . '/';
$subtheme_url = get_bloginfo('template_directory') . '/ctr/subthemes/' . $subtheme . '/';
$stylesheet_url = $subtheme_url . 'style.css';

$path = TEMPLATEPATH . '/includes';
set_include_path(get_include_path() . PATH_SEPARATOR . $path);
include_once('Zend/Config/Ini.php');
$subtheme_settings = new Zend_Config_Ini($subtheme_dir . 'config.ini', NULL, array('allowModifications' => true));

foreach($subtheme_settings->scripts as $script){
	wp_enqueue_script($script->handle, get_bloginfo('template_directory') . $script->src, $script->dependencies->toArray());
}

// load the colors from the themes config
$colors = $subtheme_settings->default_colors;
$admin_settings = $subtheme_settings->admin;

if(!in_array('ctr_ad_headerImg',$admin_settings->hide_fields->toArray()))
	$headerImg = get_option('ctr_ad_headerImg');

$hide_referrers = get_option('ctr_ad_hide_referrers');
if($hide_referrers) $hide_referrers = explode("\n",$hide_referrers);

// Determine the ad formatting for this page
global $layout;
global $ads;
global $layout_channel;

$ads['336'] = stripslashes(get_option('ctr_ad336'));
$ads['160'] = stripslashes(get_option('ctr_ad160'));
$ads['728'] = stripslashes(get_option('ctr_ad728'));
$ads['728 link unit'] = stripslashes(get_option('ctr_ad728lu'));

$sitename = stripslashes(get_option('ctr_ad_sitename'));
	
$use_tagline = get_option('ctr_ad_use_tagline');
$tagline = get_bloginfo('description');

$show_comments = get_option('ctr_ad_show_comments');
$show_tags = get_option('ctr_ad_show_tags');

if($disable_ads === NULL) $disable_ads = get_option('ctr_ad_disable');

if(isset($_SESSION['ctr_disable_ads'])) $disable_ads = true;
else{
    if(is_array($hide_referrers) && count($hide_referrers) > 0)
    {
    	foreach($hide_referrers as $r)
    	{
    		if($_SERVER['HTTP_REFERER'] && !empty($r) && stristr($_SERVER['HTTP_REFERER'], $r))
    		{
    			$disable_ads = true;
    			$_SESSION['ctr_disable_ads'] = true;
    		}
    	}
    }
}

$layouts = get_option('ctr_ad_layouts');
$override_colors = get_option('ctr_ad_color_override');

if($override_colors){
    $sitebg = get_option('ctr_ad_sitebg');
    $colors->sitebg = $sitebg;
    
    if(get_option('ctr_lcol_bg')) $colors->lcol_bg = get_option('ctr_lcol_bg');
    if(get_option('ctr_rcol_bg')) $colors->rcol_bg = get_option('ctr_rcol_bg');
    if(get_option('ctr_container_bg')) $colors->container_bg = get_option('ctr_container_bg');
    if(get_option('ctr_menubar_bg')) $colors->menubar_bg = get_option('ctr_menubar_bg');
    if(get_option('ctr_ad_linkcolor')) $colors->link = get_option('ctr_ad_linkcolor');
}

if(!$colors->menubar_bg) $colors->menubar_bg = $colors->lu_bg;

if(!$disable_ads){
	$layoutchoice = rand() % count($layouts);
	$layout = $layouts[$layoutchoice];
	$layout_channel = get_option('ctr_' . $layout . '_channel');

	// Automatically set the colors for the ads
	foreach($ads as $key => $ad)
	{	
		if(!$override_colors)
		{	
			$linkcolor = $colors->link;
			$urlcolor = $colors->url;
			$bg = $colors->bg;
			$text = $colors->text;
			$border = $colors->border;
			
			$lu_link = $colors->lu_link;
			$lu_url = $colors->lu_url;
			$lu_bg = $colors->lu_bg;
			$lu_text = $colors->lu_text;
			$lu_border = $colors->lu_border;
		}else{
			$linkcolor = get_option('ctr_ad_linkcolor'); 
			$urlcolor = get_option('ctr_ad_urlcolor');
			$bg = get_option('ctr_ad_bg');
			$text = get_option('ctr_ad_text');
			$border = get_option('ctr_ad_border');
			
			$lu_link = get_option('ctr_ad_lu_link');
			$lu_url = get_option('ctr_ad_lu_url');
			$lu_bg = get_option('ctr_ad_lu_bg');
			$lu_text = get_option('ctr_ad_lu_text');
			$lu_border = get_option('ctr_ad_lu_border');
		}
		
		// Add the layout channel to the ad, if tracking is enabled
		if(get_option('ctr_channel_tracking') && $layout_channel && stristr($key,'link unit') === FALSE)
		{
		    //check for presence of google_ad_channel
		    if(stristr($ad,'google_ad_channel') === FALSE)
		    {
		        $ad = str_ireplace("google_ad_width", "google_ad_channel=\"$layout_channel\";\ngoogle_ad_width",$ad);
		    }else{
		        $pattern = '/google_ad_channel="([0-9]+)"/';
		        $ad = preg_replace($pattern,'google_ad_channel="$1+' . $layout_channel . '"',$ad);
		    }
		}
		
		// Perform color replacement
		if(stristr($key,'link unit') === FALSE)
		{
			$ad = str_ireplace("google_ad_width", "google_color_link = \"$linkcolor\";\ngoogle_color_url = \"$urlcolor\";\ngoogle_color_border = \"$border\"\ngoogle_color_bg = \"$bg\";\ngoogle_color_text = \"$text\";\ngoogle_ad_width",$ad);
			$ads[$key] = $ad;
		}else{
			$ad = str_ireplace("google_ad_width", "google_color_link = \"$lu_link\";\ngoogle_color_url = \"$lu_url\";\ngoogle_color_border = \"$lu_border\"\ngoogle_color_bg = \"$lu_bg\";\ngoogle_color_text = \"$lu_text\";\ngoogle_ad_width",$ad);
			$ads[$key] = $ad;
		}
	}
	
}else $layout = false;
?>