<?php
/**
 * @package WordPress
 * @subpackage CTR Theme
 * @since CTR Theme 1.0
 */

require_once(TEMPLATEPATH . '/ctr/ctr-setup.php');
?><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<title><?php
	/*
	 * Print the <title> tag based on what is being viewed.
	 */
	global $page, $paged;

	if((is_home() || is_front_page()) && $ht = get_option('ctr_home_title')) echo $ht;
	else{
    	wp_title( '|', true, 'right' );
    
    	// Add the blog name.
    	bloginfo( 'name' );
    
    	// Add the blog description for the home/front page.
    	$site_description = get_bloginfo( 'description', 'display' );
    	if ( $site_description && ( is_home() || is_front_page() ) )
    		echo " | $site_description";
    
    	// Add a page number if necessary:
    	if ( $paged >= 2 || $page >= 2 )
    		echo ' | ' . sprintf( __( 'Page %s', 'ctrtheme' ), max( $paged, $page ) );
	}
	?></title>
<link rel="profile" href="http://gmpg.org/xfn/11" />
<link rel="stylesheet" type="text/css" media="all" href="<?php bloginfo('stylesheet_url'); ?>" />
<link rel="stylesheet" type="text/css" media="all" href="<?php echo $stylesheet_url; ?>" />
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
<style type="text/css">
<?php if(isset($colors->sitebg)){ ?>
body{
	background:<?php echo $colors->sitebg; ?>;
}
<?php } ?>
a, #footer a{
	color:<?php echo $colors->link; ?>;
}
<?php if(isset($colors->footerbg)){ ?>
#footer{
	background:<?php echo $colors->footerbg; ?>;
}
<?php }
if($colors->container_bg) echo '#main{ background: ' . $colors->container_bg . '; }';
if($colors->lcol_bg) echo '#leftCol{ background: ' . $colors->lcol_bg . '; }';
if($colors->rcol_bg) echo '#rightCol{ background: ' . $colors->rcol_bg . '; }';
if($colors->menubar_bg) echo '#menuBar{ background: ' . $colors->menubar_bg . '; }';
?>
<?php if($ctr_custom_css = get_option('ctr_custom_css')) echo $ctr_custom_css;?>
</style>
<?php wp_head(); ?>
<?php if($ga_code = get_option('ctr_ga_code')) echo stripslashes($ga_code); ?>
</head>
<?php include($subtheme_dir . 'body.php'); ?>