<?php
$prefix = 'ctr_';
$shortname = "ctr";

$meta_box = array(
    'id' => 'ctr-meta-box',
    'title' => 'CTR Theme Options',
    'page' => array('post','page'),
    'context' => 'normal',
    'priority' => 'high',
    'fields' => array(
        array(
            'name' => __("Meta Description","ctrtheme"),
            'desc' => __('Enter your meta description here.<br /><span id="meta_desc_char_count">155</span> characters remaining',"ctrtheme"),
            'id' => $prefix . 'meta_description',
            'type' => 'textarea',
            'std' => ''
        ),
        array(
            'name' => __("Meta Keywords","ctrtheme"),
            'desc' => __('Enter your meta keywords here. Use commas to separate them.',"ctrtheme"),
            'id' => $prefix . 'meta_keywords',
            'type' => 'text',
            'std' => ''
        ),
        array(
            'name'  => __("Disable Ads on this Page","ctrtheme"),
            'id'    => $prefix . 'disable_ads',
            'type'  => 'checkbox',
            'std'	=> __('Do not display ads on this page',"ctrtheme"),
            'desc'	=> __('Check this box if you want to hide ads from being displayed on this page',"ctrtheme")
        ),
        /*array(
            'name' => __("Force Specific Ad Layout","ctrtheme"),
            'id' => $prefix . 'force_layout',
            'type' => 'checkbox',
            'std'	=> __('Force a specific ad layout on this page',"ctrtheme"),
            'desc'	=> __('Check this box if you want to select a specific ad layout for this page'
        ,"ctrtheme"),),*/
        array(
            'name' => __("Disable Pushdown Images","ctrtheme"),
            'id' => $prefix . 'disable_pushdown',
            'type' => 'checkbox',
            'std'	=> __('Do not show pushdown images on this page',"ctrtheme"),
            'desc'	=> __('Check this box if you do not want pushdown images to display on this page'
        ,"ctrtheme"),),
        array("name" => __("Pushdown Image 1","ctrtheme"),
    		"desc" => __("Select an image to override the default pushdown images.  Should be 326 x 280 in size.","ctrtheme"),
    		"id" => $prefix."ad_pushdown1",
    		"type" => "image",
    		"std" => "",
    	),
    	array("name" => __("Pushdown Image 1 Alt Text","ctrtheme"),
    		"desc" => __("Enter the alternate text for this image","ctrtheme"),
    		"id" => $shortname."_ad_pushdown1_alt",
    		"type" => "text",
    		"std" => "",
    	),
    	array("name" => __("Pushdown Image 1 Link URL","ctrtheme"),
    		"desc" => __("If you want your pushdown image to link somewhere, enter a URL here","ctrtheme"),
    		"id" => $shortname."_ad_pushdown1_link",
    		"type" => "text",
    		"std" => "",
    	),
    	array("name" => __("Pushdown Image 2","ctrtheme"),
    		"desc" => __("Select an image to override the default pushdown images.    Should be 326 x 280 in size.","ctrtheme"),
    		"id" => $prefix."ad_pushdown2",
    		"type" => "image",
    		"std" => "",
    	),
    	array("name" => __("Pushdown Image 2 Alt Text","ctrtheme"),
    		"desc" => __("Enter the alternate text for this image","ctrtheme"),
    		"id" => $shortname."_ad_pushdown2_alt",
    		"type" => "text",
    		"std" => "",
    	),
    	array("name" => __("Pushdown Image 2 Link URL","ctrtheme"),
    		"desc" => __("If you want your pushdown image to link somewhere, enter a URL here","ctrtheme"),
    		"id" => $shortname."_ad_pushdown2_link",
    		"type" => "text",
    		"std" => "",
    	),
    )
);

add_action('admin_menu', 'ctr_add_box');

$current_page = substr(strrchr($_SERVER['PHP_SELF'], '/'), 1, -4);
if ($current_page == 'page' || $current_page == 'page-new' || $current_page == 'post' || $current_page == 'post-new') {
	add_action('admin_head', 'ctr_add_post_enctype');
	//add_action('admin_head', 'ctr_add_unlink_script');
	add_action('save_post', 'ctr_save');
}

function ctr_save($post_id)
{
    global $meta_box;
    
    // verify nonce
	if (!wp_verify_nonce($_POST['ctr_meta_box_nonce'], basename(__FILE__))) {
		return $post_id;
	}

	// check autosave
	if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
		return $post_id;
	}

	// check permissions
	if ('page' == $_POST['post_type']) {
		if (!current_user_can('edit_page', $post_id)) {
			return $post_id;
		}
	} elseif (!current_user_can('edit_post', $post_id)) {
		return $post_id;
	}

	foreach ($meta_box['fields'] as $field) {
		$name = $field['id'];

		$old = get_post_meta($post_id, $name, true);
		$new = $_POST[$field['id']];


		// changed to using WP gallery
		if ($field['type'] == 'file' || $field['type'] == 'image') {
			if (!empty($_FILES[$name])) {
    			$file = wp_handle_upload($_FILES[$name], array('test_form' => false));
    			$filename = $file['url'];
    			
			    if (!empty($filename)) {
					$wp_filetype = wp_check_filetype(basename($filename), null);
					$attachment = array(
						'post_mime_type' => $wp_filetype['type'],
						'post_title' => preg_replace('/\.[^.]+$/', '', basename($filename)),
						'post_status' => 'inherit'
					);
					
					$attach_id = wp_insert_attachment($attachment, $filename, $post_id);
					// you must first include the image.php file
					// for the function wp_generate_attachment_metadata() to work
					require_once(ABSPATH . 'wp-admin/includes/image.php');
					$attach_data = wp_generate_attachment_metadata($attach_id, $filename);
					wp_update_attachment_metadata($attach_id, $attach_data);
					
					//save the file url as post meta info
					update_post_meta($post_id,$field['id'],$filename);
				}
				
    			if(!empty($_REQUEST[$field['id'] . '-delete'])){
			        delete_post_meta($post_id, $field['id']);
			        break;
			    }
    		}
		}

		if ($field['type'] == 'wysiwyg') {
			$new = wpautop($new);
		}

		if ($field['type'] == 'textarea') {
			$new = htmlspecialchars($new);
		}

		// validate meta value
		if (isset($field['validate_func'])) {
			$ok = call_user_func(array('RW_Meta_Box_Validate', $field['validate_func']), $new);
			if ($ok === false) { // pass away when meta value is invalid
				continue;
			}
		}

		if ($new && $new != $old) {
			update_post_meta($post_id, $name, $new);
		} elseif ('' == $new && $old && $field['type'] != 'file' && $field['type'] != 'image') {
			delete_post_meta($post_id, $name, $old);
		}
	}
}

function ctr_add_post_enctype()
{
	echo '
	<script type="text/javascript">
	jQuery(document).ready(function(){
		jQuery("#post").attr("enctype", "multipart/form-data");
		jQuery("#post").attr("encoding", "multipart/form-data");
	});
	</script>';
}

/*
function add_unlink_script()
{
   echo '<script type="text/javascript">
		jQuery(document).ready(function($){
			$("a.deletefile").click(function () {
				var parent = jQuery(this).parent();

				parent.children("input.deleteinput").eq(0).val(1);
				
				parent.children("img").fadeOut("slow");
				$(this).remove();
				return false;
			});
		});
		</script>';
    
}
*/

// Add meta box
function ctr_add_box() {
    global $meta_box;

    if(is_array($meta_box['page'])){
        foreach($meta_box['page'] as $meta_box_page)
            add_meta_box($meta_box['id'], $meta_box['title'], 'ctr_show_box', $meta_box_page, $meta_box['context'], $meta_box['priority']);
    }else
        add_meta_box($meta_box['id'], $meta_box['title'], 'ctr_show_box', $meta_box['page'], $meta_box['context'], $meta_box['priority']);
}

// Callback function to show fields in meta box
function ctr_show_box() {
    global $meta_box, $post;
    
    // Use nonce for verification
    echo '<input type="hidden" name="ctr_meta_box_nonce" value="', wp_create_nonce(basename(__FILE__)), '" />';
    
    echo '<div class="rm_opts">';

    foreach ($meta_box['fields'] as $field) {
        // get current post meta data
        $meta = get_post_meta($post->ID, $field['id'], true);
        $value = $field;
        
        /*echo '<tr>',
                '<th style="width:20%"><label for="', $field['id'], '">', $field['name'], '</label></th>',
                '<td>';*/
        switch ($field['type']) {
            case 'text': ?>
                <div class="rm_input rm_text">
                    <div class="rm_label"><label for="<?php echo $value['id']; ?>"><?php echo $value['name']; ?></label></div>
                 	<div class="rm_field"><input name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" type="<?php echo $value['type']; ?>" value="<?php if ( $meta ) { echo $meta; } else { echo $value['std']; } ?>" /></div>
                 	<div class="rm_desc"><small><?php echo $value['desc']; ?></small></div>
                </div><?php
                break;
            case 'textarea': ?>
            	<div class="rm_input rm_textarea" id="<?php echo $value['id']; ?>_holder">
                	<div class="rm_label"><label for="<?php echo $value['id']; ?>"><?php echo $value['name']; ?></label></div>
                 	<div class="rm_field"><textarea name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" type="<?php echo $value['type']; ?>" cols="" rows=""><?php if ( $meta != "") { echo $meta; } else { echo $value['std']; } ?></textarea></div>
                 	<div class="rm_desc"><small><?php echo $value['desc']; ?></small></div>
                 </div><?php
                break;
            case 'select': ?>
                <div class="rm_input rm_select">
                	<div class="rm_label">
                		<label for="<?php echo $value['id']; ?>"><?php echo $value['name']; ?></label>
                	</div>
                    <div class="rm_field">
                        <select name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>">
                        <?php foreach ($value['options'] as $option) { ?>
                        		<option <?php if ($meta == $option) { echo 'selected="selected"'; } ?>><?php echo $option; ?></option><?php } ?>
                        </select>
                	</div>
                    <div class="rm_desc">
                		<small><?php echo $value['desc']; ?></small>
                    </div>
                </div><?php
                break;
                
            case 'radio': ?>
                <div class="rm_input rm_radio">
                	<div class="rm_label">
                		<label for="<?php echo $value['id']; ?>"><?php echo $value['name']; ?></label>
                	</div>
                	<?php if($value['id'] == 'ctr_ad_subtheme'){ ?>
                    	<?php $themes = ctrtheme_get_subthemes(); foreach($themes as $theme) $ctr_options[$theme] = '<img src="' . ctrtheme_get_subtheme($theme) . '" alt="'. $theme .'" />'; ?>
                    <?php }else $ctr_options = $value['options']; ?>
                    <div class="rm_radio_groups clearfix">
                    <?php foreach ($ctr_options as $option => $label) { ?>
                        <div class="rm_radio_group">
                        	<input type="radio" name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" value="<?php echo $option; ?>" <?php if ($meta == $option) { echo 'checked="checked"'; }else if(!$meta && $value['std'] == $option) echo 'checked="checked"'; ?> /> <?php echo $label; ?>
                        </div>
                    <?php } ?>  
                    </div>
                </div><?php
                break;
            case 'checkbox': ?>
            
            	<div class="rm_input rm_checkbox">
                	<div class="rm_label">
                		<label for="<?php echo $value['id']; ?>"><?php echo $value['name']; ?></label>
                	</div>
                	<div class="rm_field">
                        <?php if($meta != ""){ $checked = "checked=\"checked\""; }else{ $checked = "";} ?>
                        <input type="checkbox" name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" value="true" <?php echo $checked; ?> /><label for="<?php echo $value['id']; ?>" class="rightLabel"><?php echo $value['std']; ?></label>
                    </div>
                	<div class="rm_desc"><small><?php echo $value['desc']; ?></small></div>
                 </div><?php
                break;
                
            case "file": ?>
                <div class="rm_input rm_file" class="clearfix">
                	<div class="rm_label"><label for="<?php echo $field['id']; ?>"><?php echo $field['name']; ?></label></div>
                    <div class="rm_field"><input type="file" name="<?php echo $field['id']; ?>" id="<?php echo $field['id']; ?>" /></div>
                    <div class="rm_desc"><small><?php echo $field['desc']; ?></small><br /><?php if($meta != '') echo "<img src='$meta' alt='file' width='214' style='vertical-align:top; margin-top:10px; margin-left:16px;' />"; ?></div>
                </div>
            	<?php break;
            	
            case "image": ?>
                <div class="rm_input rm_file" class="clearfix">
                	<div class="rm_label"><label for="<?php echo $field['id']; ?>"><?php echo $field['name']; ?></label></div>
                    <div class="rm_field"><input type="file" name="<?php echo $field['id']; ?>" id="<?php echo $field['id']; ?>" /></div>
                    <div class="rm_desc"><small><?php echo $field['desc']; ?></small><br /><?php if($meta != '') echo "<img src='$meta' alt='file' width='214' style='vertical-align:top; margin-top:10px; margin-left:16px;' /><br /><input type='hidden' name='" . $value['id'] . "-delete' class='deleteinput' value='' /><a href='#' class='deletefile'>Delete Image</a>"; ?></div>
                </div>
            	<?php break;
                
        }

    }
    
    echo '</div>';
}