<?php
/**
 * @package WordPress
 * @subpackage CTR Theme
 * @since CTR Theme 1.0
 */


$themename = "CTR Theme";
$shortname = "ctr";

set_include_path(get_include_path() . PATH_SEPARATOR . TEMPLATEPATH . '/includes');

require_once( dirname( __FILE__ ) . '/lib/init.php' );

// Add footer credit
function footer_credit() {
	$disable_footer = get_option('ctr_enable_footer_link');
	if(!$enable_footer[0])
	echo '<p id="footerCredit"></p>';
}
add_action('wp_footer', 'footer_credit');
add_action('wp_footer', 'ctr_footer_scripts');

// Add meta information
add_action('wp_head', 'ctr_meta_data');

// Add script
add_action('admin_head', 'add_unlink_script');

// Set site options for admin section
$options = array (

array( "name" => $themename." Options",
	"type" => "title"),

array( "name" => __("Activation Settings","ctrtheme"),
	"type" => "section"),
array("type" => "open"),

array("name" => __("Your Email","ctrtheme"),
		"desc" => __("Enter the email address used to purchase your copy of CTR Theme","ctrtheme"),
		"id" => $shortname."_owner_email",
		"type" => "text",
		"std" => "",
),

array("name" => __("CTR Theme Activation Code","ctrtheme"),
		"desc" => __("This is the activation code that was emailed to you when you purchased CTR Theme","ctrtheme"),
		"id" => $shortname."_activation_code",
		"type" => "text",
		"std" => "",
),
array( "type" => "close"),

array( "name" => __("General Site Options","ctrtheme"),
	"type" => "section"),
array("type" => "open"),

array( "name" => __("CTR Subtheme","ctrtheme"),
	"desc" => __("Choose which subtheme you want to use for your site","ctrtheme"),
	"id" => $shortname."_ad_subtheme",
	"type" => "radio",
	"std" => __("lightInfo","ctrtheme")),

array("name" => __("Site Header","ctrtheme"),
		"desc" => __("Place secondary site name inside span tags for auto-color and size adjustment","ctrtheme"),
		"id" => $shortname."_ad_sitename",
		"type" => "text",
		"std" => "Your Example<span>Niche Site</span>",
),

array("name" => __("Site Header Image","ctrtheme"),
		"desc" => __("Recommended size is 927 x 180","ctrtheme"),
		"id" => $shortname."_ad_headerImg",
		"type" => "file",
		"std" => "",
),

array("name" => __("Pushdown Image 1","ctrtheme"),
		"desc" => __("These images are designed to place your main ad blocks right at the 'fold.'  Should be 326 x 280 in size.","ctrtheme"),
		"id" => $shortname."_ad_pushdown1",
		"type" => "file",
		"std" => "",
),

array("name" => __("Pushdown Image 1 Alt Text","ctrtheme"),
		"desc" => __("Enter the alternate text for this image","ctrtheme"),
		"id" => $shortname."_ad_pushdown1_alt",
		"type" => "text",
		"std" => "",
),

array("name" => __("Pushdown Image 1 Link URL","ctrtheme"),
		"desc" => __("If you want your pushdown image to link somewhere, enter a URL here","ctrtheme"),
		"id" => $shortname."_ad_pushdown1_link",
		"type" => "text",
		"std" => "",
),

array("name" => __("Pushdown Image 2","ctrtheme"),
		"desc" => __("These images are designed to place your main ad blocks right at the 'fold.'  Should be 326 x 280 in size.","ctrtheme"),
		"id" => $shortname."_ad_pushdown2",
		"type" => "file",
		"std" => "",
),

array("name" => __("Pushdown Image 2 Alt Text","ctrtheme"),
		"desc" => __("Enter the alternate text for this image","ctrtheme"),
		"id" => $shortname."_ad_pushdown2_alt",
		"type" => "text",
		"std" => "",
),

array("name" => __("Pushdown Image 2 Link URL","ctrtheme"),
		"desc" => __("If you want your pushdown image to link somewhere, enter a URL here","ctrtheme"),
		"id" => $shortname."_ad_pushdown2_link",
		"type" => "text",
		"std" => "",
),

array("name" => __("Show Comments","ctrtheme"),
		"desc" => __("Check this box if you want to display comments on your site","ctrtheme"),
		"id" => $shortname."_ad_show_comments",
		"type" => "checkbox",
		"std" => __("Yes, I would like to show comments.","ctrtheme")
),

array("name" => __("Show Tags","ctrtheme"),
		"desc" => __("Check this box if you want to display tags on your site","ctrtheme"),
		"id" => $shortname."_ad_show_tags",
		"type" => "checkbox",
		"std" => __("Yes, I would like to show tags.","ctrtheme")
),

array("name" => __("Use Tagline Instead of Link Unit","ctrtheme"),
		"desc" => __("Check this box if you want to display your tagline at the top of the page. Leave blank to display a Google AdSense link unit","ctrtheme"),
		"id" => $shortname."_ad_use_tagline",
		"type" => "checkbox",
		"std" => __("Yes, I would like to display my tagline, not a link unit.","ctrtheme")
),

array("name" => "Override subtheme's default color scheme",
		"desc" => __("Check this box if you want to change the default color scheme (including Google AdSense ad colors) for the current subtheme.","ctrtheme"),
		"id" => $shortname."_ad_color_override",
		"type" => "checkbox",
		"std" => __("Yes, I would like to override the default color scheme.","ctrtheme")
),

array( "name" => __("Site Background","ctrtheme"),
	"desc" => __("Will adjust the site's background color","ctrtheme"),
	"id" => $shortname."_ad_sitebg",
	"type" => "text",
	"std" => "#FFFFFF"),

array( "name" => __("Container Background","ctrtheme"),
	"desc" => __("Will adjust the container (wraps left and right columns) background color","ctrtheme"),
	"id" => $shortname."_container_bg",
	"type" => "text",
	"std" => "#FFFFFF"),

array( "name" => __("Menu Bar Background","ctrtheme"),
	"desc" => __("Will adjust the menu bar (link unit) background color","ctrtheme"),
	"id" => $shortname."_menubar_bg",
	"type" => "text",
	"std" => "#FFFFFF"),

array( "name" => __("Left Column Background","ctrtheme"),
	"desc" => __("Will adjust the left column background color","ctrtheme"),
	"id" => $shortname."_lcol_bg",
	"type" => "text",
	"std" => "#FFFFFF"),

array( "name" => __("Right Column Background","ctrtheme"),
	"desc" => __("Will adjust the right column background color","ctrtheme"),
	"id" => $shortname."_rcol_bg",
	"type" => "text",
	"std" => "#FFFFFF"),

array( "name" => __("Link Color","ctrtheme"),
	"desc" => __("Will adjust your page's link colors -- including your Google Ads","ctrtheme"),
	"id" => $shortname."_ad_linkcolor",
	"type" => "text",
	"std" => "#0000EE"),

array( "name" => __("URL Color","ctrtheme"),
	"desc" => __("The URL color for your Google Ads","ctrtheme"),
	"id" => $shortname."_ad_urlcolor",
	"type" => "text",
	"std" => "#000000"),

array( "name" => __("Background Color","ctrtheme"),
	"desc" => __("The background color for your Google Ads","ctrtheme"),
	"id" => $shortname."_ad_bg",
	"type" => "text",
	"std" => "#FFFFFF"),

array( "name" => __("Text Color","ctrtheme"),
	"desc" => __("The text color for your Google Ads","ctrtheme"),
	"id" => $shortname."_ad_text",
	"type" => "text",
	"std" => "#000000"),

array( "name" => __("Border Color","ctrtheme"),
	"desc" => __("The border color for your Google Ads","ctrtheme"),
	"id" => $shortname."_ad_border",
	"type" => "text",
	"std" => "#FFFFFF"),


array( "name" => __("Link Unit Link Color","ctrtheme"),
	"desc" => __("The link color to use for link unit ads","ctrtheme"),
	"id" => $shortname."_ad_lu_link",
	"type" => "text",
	"std" => "#0000EE"),

array( "name" => __("Link Unit URL Color","ctrtheme"),
	"desc" => __("The URL color for your Google Ads","ctrtheme"),
	"id" => $shortname."_ad_lu_url",
	"type" => "text",
	"std" => "#000000"),

array( "name" => __("Link Unit Background Color","ctrtheme"),
	"desc" => __("The background color for your Google Ads","ctrtheme"),
	"id" => $shortname."_ad_lu_bg",
	"type" => "text",
	"std" => "#FFFFFF"),

array( "name" => __("Link Unit Text Color","ctrtheme"),
	"desc" => __("The text color for your Google Ads","ctrtheme"),
	"id" => $shortname."_ad_lu_text",
	"type" => "text",
	"std" => "#000000"),

array( "name" => __("Link Unit Border Color","ctrtheme"),
	"desc" => __("The border color for your Google Ads","ctrtheme"),
	"id" => $shortname."_ad_lu_border",
	"type" => "text",
	"std" => "#FFFFFF"),

array( "name" => __("Custom CSS","ctrtheme"),
	"desc" => __("Enter any custom CSS you'd like to have implemented on the site.","ctrtheme"),
	"id" => $shortname."_custom_css",
	"type" => "textarea",
	"std" => ""),

array( "name" => __("Google Analytics Code","ctrtheme"),
	"desc" => __("You can paste your Google Analytics or other tracking code in this box. This will be automatically added to all pages.","ctrtheme"),
	"id" => $shortname."_ga_code",
	"type" => "textarea",
	"std" => ""),

array( "name" => __("Footer Scripts","ctrtheme"),
	"desc" => __("Add any scripts / code that you want to have execute right before the &lt;/body&gt; tag","ctrtheme"),
	"id" => $shortname."_footer_script",
	"type" => "textarea",
	"std" => ""),

array("name" => __("Disable CTR Theme footer link","ctrtheme"),
		"desc" => __("Check this box if you don't want to link back to CTR Theme's website in your site's footer.","ctrtheme"),
		"id" => $shortname."_disable_footer_link",
		"type" => "checkbox",
		"std" => ""
),

array( "type" => "close"),

array( "name" => __("AdSense Options","ctrtheme"),
	"type" => "section"),
array("type" => "open"),

array("name" => __("Disable Ad Serving","ctrtheme"),
		"desc" => __("Turn off ad serving (good if you're applying to a manually reviewed directory or requesting links from reputable sources)","ctrtheme"),
		"id" => $shortname."_ad_disable",
		"type" => "checkbox",
		"std" => __("Disable ad serving","ctrtheme")
),

array("name" => __("Hide Ads from Specific Referrers","ctrtheme"),
		"desc" => __("Allows you to disable ads for specific referring sites (enter one per line -- evaluated as a braod match, so typing 'yahoo.com' will match 'www.yahoo.com', 'dir.yahoo.com', etc.","ctrtheme"),
		"id" => $shortname."_ad_hide_referrers",
		"type" => "textarea",
		"std" => ""
),

array("name" => __("AdSense 160 x 600 Code","ctrtheme"),
		"desc" => __("Enter the code for your AdSense 160 x 600 Skyscraper ad","ctrtheme"),
		"id" => $shortname."_ad160",
		"type" => "textarea",
		"std" => ""
),
array("name" => __("AdSense 336 x 280 Code","ctrtheme"),
		"desc" => __("Enter the code for your AdSense 336 x 280 ad","ctrtheme"),
		"id" => $shortname."_ad336",
		"type" => "textarea",
		"std" => ""
),
array("name" => __("AdSense 728 x 90 Code","ctrtheme"),
		"desc" => __("Enter the code for your AdSense 728 x 90 ad","ctrtheme"),
		"id" => $shortname."_ad728",
		"type" => "textarea",
		"std" => ""
),
array("name" => __("AdSense 728 x 15 Link Unit Code","ctrtheme"),
		"desc" => __("Enter the code for your AdSense 728 x 15 link unit","ctrtheme"),
		"id" => $shortname."_ad728lu",
		"type" => "textarea",
		"std" => ""
),

array( "name" => __("Ad Layouts","ctrtheme"),
	"desc" => __("Choose which ad layouts to use (if more than one selected, layout will be randomly selected from chosen options).","ctrtheme"),
	"id" => $shortname."_ad_layouts",
	"type" => "checkboxes",
	"options" => array(
		"roadblock" => "",
		"336-left" => "",
		"336-right" => "",
		"728" => "",
		"doublestack-left" => "",
		"doublestack-right" => "",
		"bottomblock" => "",
),
	"std" => __("all","ctrtheme")),

array("name" => __("Track Layout Performance","ctrtheme"),
		"desc" => __("Allows you to add channel IDs for each ad block and layout type","ctrtheme"),
		"id" => $shortname."_channel_tracking",
		"type" => "checkbox",
		"std" => __("Use ad channels to track layout performance via AdSense","ctrtheme")
),

array( "name" => __("Roadblock Channel ID","ctrtheme"),
    	"desc" => __("The channel ID for the \"Roadblock\" layout","ctrtheme")."<br /><img src=\"" . get_bloginfo("template_directory") . "/images/ad-layouts/roadblock.jpg\" />",
    	"id" => $shortname."_roadblock_channel",
    	"type" => "text",
    	"std" => ""),

array( "name" => __("336 Left Channel ID","ctrtheme"),
    	"desc" =>__( "The channel ID for the \"336 Left\" layout","ctrtheme")."<br /><img src=\"" . get_bloginfo("template_directory") . "/images/ad-layouts/336-left.jpg\" />",
    	"id" => $shortname."_336-left_channel",
    	"type" => "text",
    	"std" => ""),

array( "name" => __("336 Right Channel ID","ctrtheme"),
    	"desc" => __("The channel ID for the \"336 Right\" layout","ctrtheme")."<br /><img src=\"" . get_bloginfo("template_directory") . "/images/ad-layouts/336-right.jpg\" />",
    	"id" => $shortname."_336-right_channel",
    	"type" => "text",
    	"std" => ""),

array( "name" => __("728 Top","ctrtheme"),
    	"desc" => __("The channel ID for the \"728 Top\" layout","ctrtheme")."<br /><img src=\"" . get_bloginfo("template_directory") . "/images/ad-layouts/728.jpg\" />",
    	"id" => $shortname."_728_channel",
    	"type" => "text",
    	"std" => ""),

array( "name" => __("Doublestack Left","ctrtheme"),
    	"desc" => __("The channel ID for the \"Doublestack Left\" layout","ctrtheme")."<br /><img src=\"" . get_bloginfo("template_directory") . "/images/ad-layouts/doublestack-left.jpg\" />",
    	"id" => $shortname."_doublestack-left_channel",
    	"type" => "text",
    	"std" => ""),

array( "name" => __("Doublestack Right","ctrtheme"),
    	"desc" => __("The channel ID for the \"Doublestack Right\" layout","ctrtheme")."<br /><img src=\"" . get_bloginfo("template_directory") . "/images/ad-layouts/doublestack-right.jpg\" />",
    	"id" => $shortname."_doublestack-right_channel",
    	"type" => "text",
    	"std" => ""),

array( "name" => __("Bottomblock","ctrtheme"),
    	"desc" => __("The channel ID for the \"Bottomblock\" layout","ctrtheme")."<br /><img src=\"" . get_bloginfo("template_directory") . "/images/ad-layouts/bottomblock.jpg\" />",
    	"id" => $shortname."_bottomblock_channel",
    	"type" => "text",
    	"std" => ""),


array( "type" => "close"),

array( "name" => __("Homepage SEO Options","ctrtheme"),
	"type" => "section"),
array("type" => "open"),
array("name" => __("Homepage Title","ctrtheme"),
    		"desc" => __("Override the post title for the homepage","ctrtheme"),
    		"id" => $shortname."_home_title",
    		"type" => "text",
    		"std" => "",
),
array("name" => __("Homepage Description","ctrtheme"),
    		"desc" => __("Enter the meta description for the homepage","ctrtheme"),
    		"id" => $shortname."_home_desc",
    		"type" => "textarea",
    		"std" => ""
),
array("name" => __("Homepage Keywords","ctrtheme"),
    		"desc" => __("Enter the keywords for the homepage","ctrtheme"),
    		"id" => $shortname."_home_keywords",
    		"type" => "textarea",
    		"std" => ""
),

array( "type" => "close")
);

add_action('init','setTransientDuration',5);
function setTransientDuration() {
	$theme_transient_duration=get_site_transient(THEME_NAME . '_transient_duration');
	if (!$theme_transient_duration) {
		$durationurl =  'http://updates.ctrtheme.com/durationTime.json';
		$durationJson=wp_remote_retrieve_body(wp_remote_get($durationurl));
		
		if ( $durationJson == 'error' || is_wp_error($durationJson)) {
			set_site_transient(THEME_NAME . '_transient_duration', get_option(THEME_NAME."get_transient_duration"),get_option(THEME_NAME."get_transient_duration"));
		} else {
			$durationTimes = json_decode($durationJson,true);
			//read all transient values from array and set the options
			if (is_numeric($durationTimes["transientDuration"])&&($durationTimes["transientDuration"]<(60*60*24*30))) {
				update_option(THEME_NAME."get_transient_duration",$durationTimes["transientDuration"]);
				set_site_transient(THEME_NAME . '_transient_duration', get_option(THEME_NAME."get_transient_duration"), get_option(THEME_NAME."get_transient_duration"));
			} else {
				update_option(THEME_NAME."get_transient_duration",60*60*24);
			}

			if (is_numeric($durationTimes["act_duration"])&&($durationTimes["act_duration"]<(60*60*24*30))) {
				update_option(THEME_NAME."act_transient_duration",$durationTimes["act_duration"]);
			} else {
				update_option(THEME_NAME."act_transient_duration",60*60*24);
			}

			if (is_numeric($durationTimes["update_duration"])&&($durationTimes["update_duration"]<(60*60*24*30))) {
				update_option(THEME_NAME."upgrade_transient_duration",$durationTimes["update_duration"]);
			} else {
				update_option(THEME_NAME."upgrade_transient_duration",60*60*24);
			}

		}
	}
}






add_action('admin_menu', 'ctr_add_admin');
function ctr_add_admin() {
	global $themename, $shortname, $options;

	if ( isset($_GET['page']) && $_GET['page'] == basename(__FILE__) ) {
		if ( isset($_REQUEST['action']) && 'save' == $_REQUEST['action'] ) {
			foreach ($options as $value) {
				if($value['type'] != 'file'){
					if (!array_key_exists('id',$value)) continue; 
					if( isset( $_REQUEST[$value['id']])) {
						update_option( $value['id'], $_REQUEST[$value['id']]);
					}else{
						delete_option($value['id']);
					}
				}else{
					if(!empty($_REQUEST[$value['id'] . '-delete'])){
						delete_option($value['id']);
						break;
					}
					if ($_FILES[$value['id']]) {
						$overrides = array('test_form' => false);
						$file = wp_handle_upload($_FILES[$value['id']], $overrides);
						if(!array_key_exists('error',$file))
						update_option($value['id'], $file['url']);
					}
				}
			}
			header("Location: admin.php?page=functions.php&saved=true");
			die;
		}
		else if( isset($_REQUEST['action']) && 'reset' == $_REQUEST['action'] ) {
			foreach ($options as $value) {
				delete_option( $value['id'] );
			}
			header("Location: admin.php?page=functions.php&reset=true");
			die;
		}
	}
	add_menu_page($themename, $themename, 'administrator', basename(__FILE__), 'ctr_admin');
}

add_action('admin_init', 'ctr_add_init');
function ctr_add_init() {
	$file_dir=get_bloginfo('template_directory');
	wp_enqueue_style("ctr-theme_admin", $file_dir."/css/admin.css", false, "1.0", "all");
	wp_enqueue_style("functions", $file_dir."/functions/functions.css", false, "1.0", "all");
	wp_enqueue_script("rm_script", $file_dir."/functions/rm_script.php", false, "1.0");
}

function ctr_admin() {

	global $themename, $shortname, $options;
	$i=0;
	$_REQUEST=stripslashes_deep($_REQUEST);
	if ( isset($_REQUEST['saved']) && $_REQUEST['saved'] ) echo '<div id="message" class="updated fade"><p><strong>'.$themename.' settings saved.</strong></p></div>';
	if ( isset($_REQUEST['reset']) && $_REQUEST['reset'] ) echo '<div id="message" class="updated fade"><p><strong>'.$themename.' settings reset.</strong></p></div>';

	?>
<div class="wrap rm_wrap">
	<h2>
	<?php echo $themename; ?>
		Settings
	</h2>

	<div class="rm_opts">
		<form method="post" autocomplete="off" enctype="multipart/form-data">
		<?php foreach ($options as $value) {
			switch ( $value['type'] ) {

				case "open":
					?>
					<?php break;
case "close":
	?>
	</div>
</div>
<br />
<?php break;

case "title":
	?>
<p>
	To easily change the
	<?php echo $themename;?>
	settings, you can use the menu below.
</p>

<?php break;
case 'text':
	?>

<div class="rm_input rm_text">
	<div class="rm_label">
		<label for="<?php echo $value['id']; ?>"><?php echo $value['name']; ?>
		</label>
	</div>
	<div class="rm_field">
		<input name="<?php echo $value['id']; ?>"
			id="<?php echo $value['id']; ?>" type="<?php echo $value['type']; ?>"
			<?php 
			/*  Commented Sandeep for get_option
			 * value="<?php if ( get_settings( $value['id'] ) != "") { echo stripslashes(get_settings( $value['id'])  ); } else { echo $value['std']; } ?>" />
			 */
			?>
			value="<?php if ( get_option( $value['id'] ) != "") { echo stripslashes(get_option( $value['id'])  ); } else { echo $value['std']; } ?>" />
			
	</div>
	<div class="rm_desc">
		<small><?php echo $value['desc']; ?> </small>
	</div>

</div>


<?php
break;

case 'textarea':
	?>

<div class="rm_input rm_textarea">
	<div class="rm_label">
		<label for="<?php echo $value['id']; ?>"><?php echo $value['name']; ?>
		</label>
	</div>
	<div class="rm_field">
		<textarea name="<?php echo $value['id']; ?>"
			type="<?php echo $value['type']; ?>" cols="" rows=""><?php if ( get_option( $value['id'] ) != "") {
				echo stripslashes(get_option( $value['id']) ) ;
			} else { echo $value['std'];} ?></textarea>
	</div>
	<div class="rm_desc">
		<small><?php echo $value['desc']; ?> </small>
	</div>
</div>

<?php
break;

case 'select':
	?>

<div class="rm_input rm_select">
	<div class="rm_label">
		<label for="<?php echo $value['id']; ?>"><?php echo $value['name']; ?>
		</label>
	</div>
	<div class="rm_field">
		<select name="<?php echo $value['id']; ?>"
			id="<?php echo $value['id']; ?>">
			<?php foreach ($value['options'] as $option) { ?>
			<option
			<?php if (get_option( $value['id'] ) == $option) { echo 'selected="selected"'; } ?>>
			<?php echo $option; ?></option>
			<?php } ?>
</select>
	</div>
	<div class="rm_desc">
		<small><?php echo $value['desc']; ?> </small>
	</div>
</div>


<?php
break;

case 'radio':
	?>

<div class="rm_input rm_radio">
	<div class="rm_label">
		<label for="<?php echo $value['id']; ?>"><?php echo $value['name']; ?>
		</label>
	</div>
	<?php if($value['id'] == 'ctr_ad_subtheme'){ ?>
    	<?php $themes = ctrtheme_get_subthemes(); foreach($themes as $theme) $ctr_options[$theme] = '<img src="' . ctrtheme_get_subtheme($theme) . '" alt="'. $theme .'" />'; ?>
    <?php }else $ctr_options = $value['options']; ?>
<div class="rm_radio_groups clearfix">
<?php foreach ($ctr_options as $option => $label) { ?>
<div class="rm_radio_group">
<input type="radio" name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" value="<?php echo $option; ?>" <?php if (get_option( $value['id'] ) == $option) { echo 'checked="checked"'; }else if(!get_option( $value['id'] ) && $value['std'] == $option) echo 'checked="checked"'; ?> /> <?php echo $label; ?>
</div>
<?php } ?>

</div>
</div>


<?php
break;

case 'checkboxes':
	?>
<div class="rm_input rm_checkboxes">
	<label for="<?php echo $value['id']; ?>"><?php echo $value['name']; ?>
	</label>
	<div class="rm_checkbox_groups clearfix">
	<?php foreach ($value['options'] as $option => $label) {
		if($value['id'] == 'ctr_ad_layouts') $label = '<img src="' . get_bloginfo('template_directory') . '/images/ad-layouts/' . $option . '.jpg" alt="ad layout option"/>';
		?>
		<div class="rm_checkbox_group">
			<input type="checkbox" name="<?php echo $value['id']; ?>[]"
				id="<?php echo $value['id']; ?>" value="<?php echo $option; ?>"



				<?php if (get_option( $value['id'] ) && in_array($option, get_option( $value['id'] ))){ echo 'checked="checked"'; }else if(!get_option($value['id']) && ($value['std'] == $option || $value['std'] == 'all')) echo 'checked="checked"'; ?> />
			 <?php echo $label; ?>
</div>
<?php } ?>

</div>
</div>


<?php
break;

case "file": ?>

<div class="rm_input rm_file" class="clearfix">
	<div class="rm_label">
		<label for="<?php echo $value['id']; ?>"><?php echo $value['name']; ?>
		</label>
	</div>
	<div class="rm_field">
		<input type="file" name="<?php echo $value['id']; ?>"
			id="<?php echo $value['id']; ?>" />
	</div>
	<div class="rm_desc">
		<small><?php echo $value['desc']; ?> </small><br />
		<?php if($file = get_option($value['id'])) echo "<img src='$file' alt='file' width='214' style='vertical-align:top; margin-top:10px; margin-left:16px;' /><br /><input type='hidden' name='" . $value['id'] . "-delete' class='deleteinput' value='' /><a href='#' class='deletefile'>Delete Image</a>"; ?></div>
</div>


<?php break;

case "checkbox":
	?>

<div class="rm_input rm_checkbox">
	<div class="rm_label">
		<label for="<?php echo $value['id']; ?>"><?php echo $value['name']; ?>
		</label>
	</div>
	<div class="rm_field">
	<?php if(get_option($value['id'])){
		$checked = "checked=\"checked\"";
	}else{ $checked = "";
	} ?>
		<input type="checkbox" name="<?php echo $value['id']; ?>"
			id="<?php echo $value['id']; ?>" value="true"
				


			<?php echo $checked; ?> /><label for="<?php echo $value['id']; ?>"
			class="rightLabel"><?php echo $value['std']; ?> </label>
	</div>

	<div class="rm_desc">
		<small><?php echo $value['desc']; ?> </small>
	</div>
</div>


<?php break;

case "section":

	$i++;

	?>

<div class="rm_section">
	<div class="rm_title clearfix">
		<h3>
			<img
				src="<?php bloginfo('template_directory')?>/functions/images/trans.png"
				class="inactive" alt=""">
			<?php echo $value['name']; ?></h3>
		<span class="submit"><input name="save<?php echo $i; ?>" type="submit"
			value="Save changes" /> </span>
	</div>
	<div class="rm_options clearfix">

	<?php break;

			}
		}
		?>

		<input type="hidden" name="action" value="save" /> <input
			type="submit" name="save" class="button" value="Save Changes" />
		</form>
		<form method="post">
			<p class="submit">
				<input name="reset" type="submit" value="Reset" /> <input
					type="hidden" name="action" value="reset" />
			</p>
		</form>
	</div>

<?php
}


/**
 * Register widgetized areas, including two sidebars and four widget-ready columns in the footer.
 *
 * To override ctrtheme_widgets_init() in a child theme, remove the action hook and add your own
 * function tied to the init hook.
 *
 * @since Twenty Ten 1.0
 * @uses register_sidebar
 */
function ctrtheme_widgets_init() {
    
    // Load widget areas from INI file
    $ini = ctr_load_subtheme_config();
    
    if(count($ini->widget_areas))
    {
        foreach($ini->widget_areas as $w)
        {
            register_sidebar( array(
        		'name' => __( $w->name, 'ctrtheme' ),
        		'id' => "{$w->id}",
        		'description' => __( "{$w->description}", 'ctrtheme' ),
        		'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
        		'after_widget' => '</li>',
        		'before_title' => '<h3 class="widget-title">',
        		'after_title' => '</h3>',
        	) );
        }
    }
    
	// Area 1, located at the top of the sidebar.
	register_sidebar( array(
		'name' => __( 'Left Col above 160x600 ad', 'ctrtheme' ),
		'id' => 'left-col-above-160',
		'description' => __( 'Widget area above 160x600 ad', 'ctrtheme' ),
		'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );

	// Area 2, located at the bottom of the sidebar. Empty by default.
	register_sidebar( array(
		'name' => __( 'Left Col below 160x600 ad', 'ctrtheme' ),
		'id' => 'left-col-below-160',
		'description' => __( 'Widget area below 160x600 ad', 'ctrtheme' ),
		'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );
	
	// Area 3, located at the bottom of the page.
	register_sidebar( array(
		'name' => __( 'Privacy, etc', 'ctrtheme' ),
		'id' => 'footer-privacy',
		'description' => __( 'Footer widget perfect for privacy policy, TOS, etc', 'ctrtheme' ),
		'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );
}
/** Register sidebars by running ctrtheme_widgets_init() on the widgets_init hook. */
add_action( 'widgets_init', 'ctrtheme_widgets_init' );

function ctrtheme_custom_excerpt_more( $output ) {
	if ( has_excerpt() && ! is_attachment() ) {
		$output .= ctrtheme_continue_reading_link();
	}
	return $output;
}
add_filter( 'get_the_excerpt', 'ctrtheme_custom_excerpt_more' );

function ctrtheme_continue_reading_link() {
	return ' <a href="'. get_permalink() . '">' . __( 'Continue reading', 'ctrtheme' ) . '</a>';
}

function ctrtheme_auto_excerpt_more( $more ) {
	return ' &hellip;' . ctrtheme_continue_reading_link();
}

function ctrtheme_get_subthemes()
{
	$themedir = TEMPLATEPATH . '/ctr/subthemes/';
	if ($dh = opendir($themedir)){
		while (($folder = readdir($dh)) !== false){
			if($folder != '.' && $folder != '..' && is_dir($themedir . $folder)) $themes[] = $folder;
	    }
	    closedir($dh);
    }
	return $themes;
}

function ctrtheme_get_subtheme($name)
{
	$themedir = TEMPLATEPATH . '/ctr/subthemes/' . $name . '/';
	$themeurl = get_bloginfo('template_directory') . '/ctr/subthemes/' . $name . '/';
	if(is_file($themedir . $name . '.jpg')) return $themeurl . $name . '.jpg';
	else echo $themedir . $name . '.jpg<br />' . $themeurl . $name . '.jpg';
}

function ctr_footer_scripts(){
    global $post;
    $footer_scripts = stripslashes(get_option('ctr_footer_script'));
    if($footer_scripts) echo $footer_scripts;
}

function ctr_meta_data(){
    global $post;
    global $ctr_custom;

    $meta_desc = $meta_keywords = false;
    
    if(is_array($ctr_custom) && array_key_exists('ctr_meta_description', $ctr_custom)) $meta_desc = $ctr_custom['ctr_meta_description'][0];
    if(is_array($ctr_custom) && array_key_exists('ctr_meta_keywords', $ctr_custom)) $meta_keywords = $ctr_custom['ctr_meta_keywords'][0];
    
    // Override with homepage-specific settings if they exist
    if((is_home() || is_front_page()) && $hd = get_option('ctr_home_desc')) $meta_desc = $hd;
    if((is_home() || is_front_page()) && $hk = get_option('ctr_home_keywords')) $meta_keywords = $hk;

    if($meta_desc) echo "<meta name=\"description\" content=\"$meta_desc\" />";
    if($meta_keywords) echo "<meta name=\"keywords\" content=\"$meta_keywords\" />";
}

add_filter( 'excerpt_more', 'ctrtheme_auto_excerpt_more' );

if(!function_exists('home_url')){
  function home_url($path = '/'){
    return get_bloginfo('url') . $path;
  }
}

add_action( "admin_print_scripts-post.php", 'ctr_meta_counter' );
add_action( "admin_print_scripts-post-new.php", 'ctr_meta_counter' );

function ctr_meta_counter(){
    $file_dir=get_bloginfo('template_directory');
    wp_enqueue_script("ctr_meta_counter", $file_dir . "/admin/js/ctr_meta_counter.js", false, "1.0");
}

/****************************
 * 	   ADSENSE SHORTCODES
 * *************************/
 add_shortcode("ctr-adsense", "ctr_adsense");
 
 /**
  * Shortcode for manual placement of ad blocks
  * 
  * Use pattern: [ctr-adsense type="link unit" size="728" float="left"]
  * @param $atts
  */
function ctr_adsense($atts)
{
    extract(shortcode_atts(array(
		"type" => '',
		"size" => '',
	    "float" => '',
        "channel" => ''
    ), $atts));
	
    $adname = 'ctr_ad' . $size;
    
    if($type == 'link unit')
        $adname .= 'lu';
        
    $ad = stripslashes(get_option($adname));
    $ad = ctr_replace_colors($adname,$ad,$type);

    // add channel information if provided in shortcode
    $ad = ctr_add_channel_to_ad($ad,$channel);
    
    return $ad;
}
 
function ctr_replace_colors($adname,$ad,$type)
{
    $override_colors = get_option('ctr_ad_color_override');
    if(!$override_colors)
    {
        // use the subtheme's default colors
        $config = ctr_load_subtheme_config();
        $colors = $config->default_colors;
        
        $linkcolor = $colors->link;
		$urlcolor = $colors->url;
		$bg = $colors->bg;
		$text = $colors->text;
		$border = $colors->border;
		
		$lu_link = $colors->lu_link;
		$lu_url = $colors->lu_url;
		$lu_bg = $colors->lu_bg;
		$lu_text = $colors->lu_text;
		$lu_border = $colors->lu_border;
    }else{
        // use the colors set in the CTR Options Panel
        $linkcolor = get_option('ctr_ad_linkcolor'); 
		$urlcolor = get_option('ctr_ad_urlcolor');
		$bg = get_option('ctr_ad_bg');
		$text = get_option('ctr_ad_text');
		$border = get_option('ctr_ad_border');
		
		$lu_link = get_option('ctr_ad_lu_link');
		$lu_url = get_option('ctr_ad_lu_url');
		$lu_bg = get_option('ctr_ad_lu_bg');
		$lu_text = get_option('ctr_ad_lu_text');
		$lu_border = get_option('ctr_ad_lu_border');
    }
    
    // Rename variable for color replacement code
    $key = $adname;
    
    // Do the color replacement
    if(stristr($key,'link unit') === FALSE)
	{
		$ad = str_ireplace("google_ad_width", "google_color_link = \"$linkcolor\";\ngoogle_color_url = \"$urlcolor\";\ngoogle_color_border = \"$border\"\ngoogle_color_bg = \"$bg\";\ngoogle_color_text = \"$text\";\ngoogle_ad_width",$ad);
		$ads[$key] = $ad;
	}else{
		$ad = str_ireplace("google_ad_width", "google_color_link = \"$lu_link\";\ngoogle_color_url = \"$lu_url\";\ngoogle_color_border = \"$lu_border\"\ngoogle_color_bg = \"$lu_bg\";\ngoogle_color_text = \"$lu_text\";\ngoogle_ad_width",$ad);
		$ads[$key] = $ad;
	}
	
	return $ad;
}

function ctr_get_active_subtheme()
{
    $subtheme = get_option('ctr_ad_subtheme');
    if(!$subtheme) $subtheme = 'lightInfo';
    return $subtheme;
}

function ctr_load_subtheme_config($subtheme = NULL)
{   
    if($subtheme === NULL)
        $subtheme = ctr_get_active_subtheme();  
    $subtheme_dir = TEMPLATEPATH . '/ctr/subthemes/' . $subtheme . '/'; 

    include_once('Zend/Config/Ini.php');
    $subtheme_settings = new Zend_Config_Ini($subtheme_dir . 'config.ini');
    
    return $subtheme_settings;
}

function ctr_add_channel_to_ad($ad,$channel)
{
    //check for presence of google_ad_channel
    if(stristr($ad,'google_ad_channel') === FALSE)
    {
        $ad = str_ireplace("google_ad_width", "google_ad_channel=\"$channel\";\ngoogle_ad_width",$ad);
    }else{
        $pattern = '/google_ad_channel="([0-9]+)"/';
        $ad = preg_replace($pattern,'google_ad_channel="$1+' . $channel . '"',$ad);
    }
    return $ad;
}

function is_shortcode_present($shortcode, $post = NULL)
{
    if($post === NULL)
        global $post;
        
    if ( FALSE === strpos($post->post_content, "[$shortcode") )
        return;
    else return true; 
}

function create_file($file, $a)
{
	$h = fopen($file, "w");
	$result = fwrite($h, $a);
	fclose($h);
	if($result) return true;
}

function add_unlink_script()
{
   echo '<script type="text/javascript">
		jQuery(document).ready(function($){
			$("a.deletefile").click(function () {
				var parent = jQuery(this).parent();

				parent.children("input.deleteinput").eq(0).val(1);
				
				parent.children("img").fadeOut("slow");
				$(this).remove();
				return false;
			});
		});
		</script>';
}

/**
 * Template for comments and pingbacks.
 */
function ctrtheme_comment( $comment, $args, $depth ) {
	$GLOBALS['comment'] = $comment;
	switch ( $comment->comment_type ) :
		case '' :
	?>
	<li <?php comment_class(); ?> id="li-comment-<?php comment_ID(); ?>">
		<div id="comment-<?php comment_ID(); ?>">
		<div class="comment-header">
			<?php echo get_avatar( $comment, 32 ); ?>
			<?php printf( __( '%s', 'ctrtheme' ), sprintf( '<cite class="fn">%s</cite>', get_comment_author_link() ) ); ?>

			<div class="comment-meta commentmetadata">
			<?php
				/* translators: 1: date, 2: time */
				printf( __( '%1$s at %2$s', 'ctrtheme' ), get_comment_date(),  get_comment_time() ); ?> <?php edit_comment_link( __( '(Edit)', 'ctrtheme' ), ' ' );
			?>
			</div><!-- .comment-meta .commentmetadata -->
		</div><!-- .comment-header -->

		<?php if ( $comment->comment_approved == '0' ) : ?>
		<div class="comment-status">
			<em class="comment-awaiting-moderation"><?php _e( 'Your comment is awaiting moderation.', 'ctrtheme' ); ?></em>
			<br />
		</div>
		<?php endif; ?>

		<div class="comment-body"><?php comment_text(); ?></div>

		<div class="reply">
			<?php comment_reply_link( array_merge( $args, array( 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?>
		</div><!-- .reply -->
	</div><!-- #comment-##  -->

	<?php
			break;
		case 'pingback'  :
		case 'trackback' :
	?>
	<li class="post pingback">
		<p><?php _e( 'Pingback:', 'ctrtheme' ); ?> <?php comment_author_link(); ?><?php edit_comment_link( __( '(Edit)', 'ctrtheme' ), ' ' ); ?></p>
	<?php
			break;
	endswitch;
}

function is_curl_installed() {
	return function_exists('curl_init') ? true : false;
}

function _log( $message ) {
	if( WP_DEBUG === true ){
		if( is_array( $message ) || is_object( $message ) ){
			error_log( print_r( $message, true ) );
		} else {
			error_log( $message );
		}
	}
}
