<?php
set_site_transient('update_themes', null);

add_filter('site_transient_update_themes', 'custom_theme_update_push');
add_filter('transient_update_themes', 'custom_theme_update_push');

function custom_theme_update_push($value) {
	
    $theme_base = basename(dirname(dirname(__FILE__)));
	$custom_theme_update = custom_theme_update_check();
	
	if ( $custom_theme_update ) {
		$value->response[$theme_base] = $custom_theme_update; // change to make this dynamic
	}
	
	return $value;
}

/**
 * Display the update nag at the top of the
 * dashboard if there is an available theme update.
 *
 * @since 1.1
 */
add_action('admin_notices', "custom_theme_update_nag");
function custom_theme_update_nag() {
	$theme_base = basename(dirname(dirname(__FILE__)));
	$custom_theme_update = custom_theme_update_check();
	
	if ( !current_user_can('update_themes') || !$custom_theme_update )
		return false;
	
	$update_url = wp_nonce_url('update.php?action=upgrade-theme&amp;theme=' . $theme_base, 'upgrade-theme_' . $theme_base);
	$update_onclick = esc_js( __('Upgrading your theme will overwrite the current installed version. Are you sure you want to upgrade?. "Cancel" to stop, "OK" to upgrade.', $theme_base) );
	
	echo '<div id="update-nag">';
	printf(__('CTR Theme %s is available. <a href="%s" class="thickbox thickbox-preview">Check out what\'s new</a> or <a href="%s" onclick="return confirm(\'%s\');">update now</a>.', $theme_base), $custom_theme_update['new_version'], $custom_theme_update['changelog'], $update_url, $update_onclick);
	_e("If the automated upgrade fails for any reason please send a mail to support@ctrtheme.com"); //TODO: Need to internationalize
	echo '</div>';
} 

function custom_theme_update_check() {
	global $wp_version;
	$theme_base = basename(dirname(dirname(__FILE__)));

	$custom_theme_update = get_site_transient(THEME_NAME . '-update');
	
	if (!$custom_theme_update) {
		$updateTransientDuration = get_option(THEME_NAME."upgrade_transient_duration");

		$url = 'http://updates.ctrtheme.com/version.html';
		$theme_latest_version = wp_remote_retrieve_body(wp_remote_post($url, $options));
		if ( $custom_theme_update == 'error' || is_wp_error($custom_theme_update) ) {
			set_site_transient(THEME_NAME . '-update', array('new_version' => THEME_VERSION), $updateTransientDuration); 
			return FALSE;
		} 
		
		if (version_compare(THEME_VERSION, $theme_latest_version, '>=')) {
					set_site_transient(THEME_NAME . '-update', array('new_version' => THEME_VERSION), $updateTransientDuration);
					return false;
				}
				else {
					
					$url = 'http://updates.ctrtheme.com/ctrupdate.php';
					$request = array(
							'slug' => $theme_base,
							'version' => THEME_VERSION
				);
				
				$options = array(
							'body' => array(
								'action' => 'theme_update', 
								'request' => base64_encode(serialize($request)),
								'api-key' => md5(get_bloginfo('url'))
				),
							'user-agent' => 'WordPress/' . $wp_version . '; ' . get_bloginfo('url')
				);
				
				$custom_theme_update = wp_remote_retrieve_body(wp_remote_post($url, $options));
				if ( $custom_theme_update == 'error' || is_wp_error($custom_theme_update) || !is_serialized($custom_theme_update) ) {
					set_site_transient(THEME_NAME . '-update', array('new_version' => THEME_VERSION), $updateTransientDuration); 
					return FALSE;
				}
					
				// Else, unserialize
				$custom_theme_update = maybe_unserialize($custom_theme_update);
				set_site_transient(THEME_NAME . '-update', $custom_theme_update, $updateTransientDuration);
				}
			}
		
		// If we're already using the latest version, return FALSE
		if ( version_compare(THEME_VERSION, $custom_theme_update['new_version'], '>=') )
		return FALSE;
		
		return $custom_theme_update;
		
}

add_action('init', 'custom_theme_update_email');
function custom_theme_update_email() {
	
	// Check for updates
	$update_check = custom_theme_update_check();
	
	// If no new version is available, stop!
	if ( !$update_check )
		return;
	//echo 'new version available'; //exit;
}