<?php

require_once(TEMPLATEPATH . '/admin/meta-boxes.php'); // Add CTR Theme meta box to pages and posts
add_action( 'ctrtheme_init', 'ctr_theme_support' );
/**
 * Activates default theme features.
 *
 * @since 1.4.4
 */
function ctr_theme_support() {
	add_theme_support( 'automatic-feed-links' );
	

}


add_action( 'ctrtheme_init', 'ctrtheme_constants' );
function ctrtheme_constants() {
	
	/** Define Theme Info Constants */
	define( 'THEME_NAME', 'ctrtheme' );
	define('THEME_VERSION','1.4.5');

	/** Define Directory Location Constants */
	define( 'PARENT_DIR', get_template_directory() );
	define( 'CHILD_DIR', get_stylesheet_directory() );
	define( 'CTR_IMAGES_DIR', PARENT_DIR . '/images' );
	define( 'CTR_LIB_DIR', PARENT_DIR . '/lib' );
	define( 'CTR_ADMIN_DIR', CTR_LIB_DIR . '/admin' );
	define( 'CTR_ADMIN_IMAGES_DIR', CTR_LIB_DIR . '/admin/images' );
	define( 'CTR_JS_DIR', CTR_LIB_DIR . '/js' );
	define( 'CTR_CSS_DIR', CTR_LIB_DIR . '/css' );
	define( 'CTR_CLASSES_DIR', CTR_LIB_DIR . '/classes' );
	define( 'CTR_FUNCTIONS_DIR', CTR_LIB_DIR . '/functions' );
	define( 'CTR_SHORTCODES_DIR', CTR_LIB_DIR . '/shortcodes' );
	define( 'CTR_STRUCTURE_DIR', CTR_LIB_DIR . '/structure' );
	define( 'CTR_LANGUAGES_DIR', CTR_LIB_DIR . '/languages' );
	
	
	/** Define Theme Dir Constants */
	define( 'THEME_DIR', get_template_directory() );
	
	define( 'CTRTHEME_LIB_DIR', THEME_DIR . '/lib' );
	define( 'CTRTHEME_WIDGETS_DIR', CTRTHEME_LIB_DIR . '/widgets' );
	
}

add_action( 'ctrtheme_init', 'ctrtheme_load_framework' );
function ctrtheme_load_framework() {
	
	/** Load Functions */
	require_once(CTR_FUNCTIONS_DIR . '/update.php'); // Include automatic updater
	require_once(CTR_FUNCTIONS_DIR . '/languages.php'); //Add languages support to CTRTheme
	
	/** Load Widgets */
	require_once( CTRTHEME_WIDGETS_DIR . '/widgets.php' );

}



/** Run the ctrtheme_init hook */
do_action( 'ctrtheme_init' );

?>