<?php
/**
 * Adds the Google Adsense Search widget.
 *
 * @category CTRTheme
 * @package  Widgets
 * @author   HBWSL
 * @license  http://www.opensource.org/licenses/gpl-license.php GPL v2.0 (or later)
 * @link     http://www.hbwsl.com/
 */

/**
 * CTRTheme Adsense Search widget class.
 *
 * @category CTRTheme
 * @package Widgets
 *
 * @since 1.4.2
 */
class CTRTheme_Google_Search extends WP_Widget {

	/**
	 * Holds widget settings defaults, populated in constructor.
	 *
	 * @var array
	 */
	protected $defaults;

	/**
	 * Constructor. Set the default widget options and create widget.
	 */
	function __construct() {
		
		$this->defaults = array(
			'title'       => '',
			'text'        => '',
			'id'          => '',
			'input_text'  => '',
			'button_text' => '',
		);

		$widget_ops = array(
			'classname'   => 'ctrtheme-search-widget',
			'description' => __( 'Displays Google Search for Adsense revenue', 'ctrtheme' ),
		);

		$this->WP_Widget( 'ctrsearch', __( 'CTRTheme - Search', 'ctrtheme' ), $widget_ops );

	}

	/**
	 * Echo the widget content.
	 *
	 * @param array $args Display arguments including before_title, after_title, before_widget, and after_widget.
	 * @param array $instance The settings for the particular instance of the widget
	 */
	function widget( $args, $instance ) {

		extract( $args );

		/** Merge with defaults */
		$instance = wp_parse_args( (array) $instance, $this->defaults );

		echo $before_widget . '<div class="gsearch">';

			if ( ! empty( $instance['title'] ) )
				echo $before_title . apply_filters( 'widget_title', $instance['title'], $instance, $this->id_base ) . $after_title;

			if ( !empty( $instance['google_search_code'] ) ) :
				echo  $instance['google_search_code'];
			endif;
		echo '</div>' . $after_widget;

	}

	/**
	 * Update a particular instance.
	 *
	 * This function should check that $new_instance is set correctly.
	 * The newly calculated value of $instance should be returned.
	 * If "false" is returned, the instance won't be saved/updated.
	 *
	 * @param array $new_instance New settings for this instance as input by the user via form()
	 * @param array $old_instance Old settings for this instance
	 * @return array Settings to save or bool false to cancel saving
	 */
	function update( $new_instance, $old_instance ) {

		$instance = $old_instance;
		$instance['google_search_code']  = $new_instance['google_search_code'];
		$instance['google_result_code']  = $new_instance['google_result_code'];
		if (get_option('google_result_code') =="") {
			add_option('google_result_code',serialize($new_instance['google_result_code']));
		} else {
			update_option('google_result_code',serialize($new_instance['google_result_code']));
		} 
		return $instance;

	}

	/**
	 * Echo the settings update form.
	 *
	 * @param array $instance Current settings
	 */
	function form( $instance ) {

		/** Merge with defaults */
		$instance = wp_parse_args( (array) $instance, $this->defaults );

?>

		<p>
			<label for="<?php echo $this->get_field_id( 'google_search_code' ); ?>"><?php _e( 'Google Search Code', 'ctrtheme' ); ?>:</label>
			<textarea id="<?php echo $this->get_field_id( 'google_search_code' ); ?>" name="<?php echo $this->get_field_name( 'google_search_code' ); ?>" class="widefat" rows="6" cols="4"><?php echo htmlspecialchars( $instance['google_search_code'] ); ?></textarea>
			
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'google_result_code' ); ?>"><?php _e( 'Google Result Code', 'ctrtheme' ); ?>:</label>
			<textarea id="<?php echo $this->get_field_id( 'google_result_code' ); ?>" name="<?php echo $this->get_field_name( 'google_result_code' ); ?>" class="widefat" rows="6" cols="4"><?php echo htmlspecialchars( $instance['google_result_code'] ); ?></textarea>
		</p>
	<?php
	}
}
?>