<?php
/**
 * The loop that displays posts.
 *
 * @package WordPress
 * @subpackage CTR Theme
 * @since CTR Theme 1.0
 */
?>

<?php /* Display Google Search Results if it exists */ 
	if (isset($_GET['q'])) {
		echo unserialize(get_option('google_result_code'));
	} else {
?>
<?php /* If there are no posts to display, such as an empty archive page */ ?>

<?php if ( ! have_posts() ) : ?>
	<div id="post-0" class="post error404 not-found">
		<h1 class="entry-title"><?php _e( 'Not Found', 'ctrtheme' ); ?></h1>
		<div class="entry-content">
			<p><?php _e( 'Apologies, but no results were found for the requested archive. Perhaps searching will help find a related post.', 'ctrtheme' ); ?></p>
			<?php get_search_form(); ?>
		</div><!-- .entry-content -->
	</div><!-- #post-0 -->
<?php endif; ?>

<?php // Start the Loop. ?>
<?php $postcount = 1;
	  while ( have_posts() ) : the_post(); ?>


<?php /* How to display all other posts. */ ?>

		<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<?php if ( is_archive() || is_search() || (is_front_page() && $postcount > 1)) : // Only display excerpts for archives and search. ?>
    		<h2 class="entry-title"><a href="<?php the_permalink(); ?>" title="<?php printf( esc_attr__( 'Permalink to %s', 'ctrtheme' ), the_title_attribute( 'echo=0' ) ); ?>" rel="bookmark"><?php the_title(); ?></a></h2>
			<div class="entry-summary">
				<?php the_excerpt(); ?>
			</div><!-- .entry-summary -->
	<?php else :
	        include(TEMPLATEPATH . '/includes/postBody.php');		
	endif; ?>

			<div class="entry-utility">
				<?php edit_post_link( __( 'Edit', 'ctrtheme' ), '<span class="meta-sep">|</span> <span class="edit-link">', '</span>' ); ?>
			</div><!-- .entry-utility -->
			
		</div><!-- #post-## -->

<?php $postcount++; ?>
<?php endwhile; // End the loop. ?>

<?php /* Display navigation to next/previous pages when applicable */ ?>
<?php if (  $wp_query->max_num_pages > 1 ) : ?>
				<div id="moreEntries" class="clearfix">
					<div class="nav-newer"><?php previous_posts_link( __( '&lt;&lt; Newer posts', 'flipwebsites' ) ); ?></div>
					<div class="nav-older"><?php next_posts_link( __( 'Older posts &gt;&gt;', 'flipwebsites' ) ); ?></div>
				</div><!-- #moreEntries-below -->
<?php endif; 
}?>
